Simility Movies Listing
[Problem Statement]

Develop a pseudo Front End Application which would let the users help list and browse top movies details conveniently.

[Minimum Requirement]

— Use of Web API to fetch movies details.

Utilise Response Parameters:

[ movie_title, director_name, actor_1_name, actor_2_name, genres, language, country, content_rating, budget, title_year, plot_keywords, movie_imdb_link ].

Implement functionality to list movies details in a web page.

— Visually interactive responsive design listing all the movies details.

— Submit Screenshot, Source code & Instructions.

[Plus Point]

— A feature to Search by name. Store the API response in local storage and make queries to that.

— Implement Sort feature (to filter result through genres, budget). Again you should be searching local storage for this and not making fresh API calls.

— href url parameter. All headings should be links which should open in new window. (Should open in new window | target="\_blank")

[Extra Work]

— Implement feature to sort movies based on title_year.(Sort based on old-to-new and new-to-old based on time).

— Create beautiful graphs/charts on the UI representing movies and their budgets and another with their year of release. You should create more graphs/charts illustrating different analysis. You are expected to use D3 JS or other similar libraries.

— Add autocomplete feature to Search movies details conveniently . Search local storage where you have stored the API Response. IndexedDB is preferred as local storage.

— Custom elegant design, fonts and icons to make web app more user-friendly.

— You may add portfolio activity comprising awesome work you have done on web application(s).

— Use your imagination and add features which would make things easier for end users.

[Deliverables]

— You are expected to code in frameworks like ReactJS and AngularJS.

— You must store API response in local storage and make queries to it. IndexedDB is preferred.

— We are expecting Generic and Robust code in ReactJS or AngularJS.

— We are expecting well indented, commented and documented code.

— Zip all your Source Code, Deployment Instructions, Screenshots and upload.

[Guide]

— Movies API: API Link

— Ideal Frontend Stack :

ReactJS/AngularJS, HTML, CSS.

D3 JS and other similar libraries.

IndexedDB, History API

— HTML5 Local Storage: http://html5demos.com/storage

— IndexedDB API :

https://developer.mozilla.org/en/docs/Web/API/IndexedDB_API https://www.tutorialspoint.com/html5/html5_indexeddb.htm

— For icons and subtle texture :

http://glyphsearch.com/

http://subtlepatterns.com/thumbnail-view/

http://codebeautify.org/jsonviewer

http://www.flaticon.com/categories

[Wireframe MVP / Reference Structure]

Mockup image with instructions

Page 1 — Home page comprising list of movies details.

Home

Page 2 — Graph page

graph

Note: Mockup design is just a reference made available to kickstart the design process, you are free to come up with your own design, we always admire creativity.

— API Specs shall be accessible once event starts.

Structure / Data Parameters:

movie_title : Title of the movie.

director_name : Director’s name.

actor_1_name : Lead actor’s name.

actor_2_name : Second lead’s name.

Genres : Genre of the movie.

Language : Spoken language in the movie.

Country : Country to which the movie belongs, like USA, India.

Content_rating : Content Rating of the movie, like PG-13, R-rated etc.

Budget : Budget of the movie in USD.

Title_year : Year in which movie released.

Plot_keywords : Keywords of the plot.

Movie_imdb_link : Movie’s IMDB Link.

Manish Bisht
Email : hi@manishbisht.me
Website : https://manishbisht.me
